/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.ShaderType;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.accessors.ProgramSourceAccessor;
import dev.djefrey.colorwheel.compile.ClrwlPipelineCompiler;
import dev.djefrey.colorwheel.compile.transform.ClrwlTransformOutput;
import dev.djefrey.colorwheel.compile.transform.ClrwlTransformPatcher;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.helpers.Tri;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.texture.TextureStage;

public class ClrwlProgramSources {
    private final Map<Key, PatchedSources> sources = new HashMap<Key, PatchedSources>();

    public PatchedSources getSources(ClrwlProgramId programId, ClrwlPipelineCompiler.OitMode oit, ProgramSet programSet, IrisRenderingPipeline pipeline) {
        ProgramSetAccessor programAccessor = (ProgramSetAccessor)programSet;
        ClrwlProgramId realProgramId = programAccessor.colorwheel$getRealClrwlProgram(programId).orElseThrow();
        boolean isCrumbling = programId == ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK;
        boolean customOutputs = oit == ClrwlPipelineCompiler.OitMode.DEPTH_RANGE || oit == ClrwlPipelineCompiler.OitMode.GENERATE_COEFFICIENTS;
        Key key = new Key(realProgramId, isCrumbling, customOutputs);
        return this.sources.computeIfAbsent(key, k -> {
            ProgramSource sources = programAccessor.colorwheel$getClrwlProgramSource(k.realProgramId()).orElseThrow();
            Map<ShaderType, List<String>> extensions = ((ProgramSourceAccessor)sources).colorwheel$getShaderExtensions();
            int[] drawBuffers = sources.getDirectives().getDrawBuffers();
            String vertexSource = ClrwlTransformPatcher.patchVertex((String)sources.getVertexSource().orElseThrow(), k.isCrumbling(), sources.getDirectives(), (Object2ObjectMap<Tri<String, TextureType, TextureStage>, String>)pipeline.getTextureMap());
            Optional<String> geometrySource = sources.getGeometrySource().map(s -> ClrwlTransformPatcher.patchGeometry(s, k.isCrumbling(), sources.getDirectives(), (Object2ObjectMap<Tri<String, TextureType, TextureStage>, String>)pipeline.getTextureMap()));
            ClrwlTransformOutput fragmentSource = ClrwlTransformPatcher.patchFragment((String)sources.getFragmentSource().orElseThrow(), k.isCrumbling(), k.customOutputs(), sources.getDirectives(), (Object2ObjectMap<Tri<String, TextureType, TextureStage>, String>)pipeline.getTextureMap());
            return new PatchedSources(vertexSource, geometrySource, fragmentSource, extensions, drawBuffers);
        });
    }

    private record Key(ClrwlProgramId realProgramId, boolean isCrumbling, boolean customOutputs) {
    }

    public record PatchedSources(String vertex, Optional<String> geometry, ClrwlTransformOutput fragment, Map<ShaderType, List<String>> extensions, int[] drawBuffers) {
    }
}

