/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.zoom.modifiers;

import io.github.ennuil.ok_zoomer.zoom.modifiers.MouseModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SmoothDouble;

public class MultipliedCinematicCameraMouseModifier
implements MouseModifier {
    private final Minecraft minecraft;
    private final SmoothDouble cursorXZoomSmoother = new SmoothDouble();
    private final SmoothDouble cursorYZoomSmoother = new SmoothDouble();
    private boolean active;
    private boolean cinematicCameraEnabled;
    private final double multiplier;

    public MultipliedCinematicCameraMouseModifier(double multiplier) {
        this.multiplier = multiplier;
        this.minecraft = Minecraft.getInstance();
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyXModifier(double cursorDeltaX, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        if (this.cinematicCameraEnabled) {
            this.cursorXZoomSmoother.reset();
            return cursorDeltaX;
        }
        return this.cursorXZoomSmoother.getNewDeltaValue(cursorDeltaX, mouseUpdateTimeDelta * this.multiplier * cursorSensitivity);
    }

    @Override
    public double applyYModifier(double cursorDeltaY, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        if (this.cinematicCameraEnabled) {
            this.cursorYZoomSmoother.reset();
            return cursorDeltaY;
        }
        return this.cursorYZoomSmoother.getNewDeltaValue(cursorDeltaY, mouseUpdateTimeDelta * this.multiplier * cursorSensitivity);
    }

    @Override
    public void tick(boolean active) {
        this.cinematicCameraEnabled = this.minecraft.options.smoothCamera;
        if (!active && this.active) {
            this.cursorXZoomSmoother.reset();
            this.cursorYZoomSmoother.reset();
        }
        this.active = active;
    }
}

