/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OkZoomerSelectionList
extends AbstractContainerWidget {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private final Minecraft minecraft;
    private final List<Entry> children;
    private IntList entryHeights;
    private int contentHeight;
    private int scrollAmount;
    private boolean scrolling;
    @Nullable
    private Entry hovered;

    public OkZoomerSelectionList(Minecraft minecraft, int width, int height, int y) {
        super(0, y, width, height, CommonComponents.EMPTY);
        this.minecraft = minecraft;
        this.children = new ArrayList<Entry>();
        this.entryHeights = new IntArrayList();
        this.contentHeight = height;
        this.scrollAmount = 0;
        this.scrolling = false;
        this.hovered = null;
        this.update();
    }

    @Nullable
    public Entry getFocused() {
        return (Entry)super.getFocused();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderListBackground(graphics);
        graphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        int i = this.getY() - this.scrollAmount;
        for (Entry child : this.children) {
            int oldI = i;
            if ((i += child.getEntryHeight()) < this.getY() || oldI > this.height + this.getY()) continue;
            int xToRender = this.getX() + this.width / 2 - this.getRowWidth() / 2;
            child.render(graphics, xToRender, oldI, this.getRowWidth(), mouseX, mouseY, delta);
        }
        graphics.disableScissor();
        this.renderListSeparators(graphics);
        if (this.contentHeight - this.height > 0) {
            this.renderScrollBar(graphics);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        Entry hovered = this.getHovered();
        if (hovered != null) {
            hovered.updateNarration(narrationElementOutput.nest());
            this.narrateListElementPosition(narrationElementOutput, hovered);
        } else {
            Entry entry = this.getFocused();
            if (entry != null) {
                entry.updateNarration(narrationElementOutput.nest());
                this.narrateListElementPosition(narrationElementOutput, entry);
            }
        }
        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, Entry entry) {
        int i;
        List<Entry> list = this.children();
        if (!list.isEmpty() && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    @NotNull
    public List<Entry> children() {
        return this.children;
    }

    @NotNull
    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    private void renderListBackground(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        ResourceLocation backgroundLocation = this.minecraft.level == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
        graphics.blit(backgroundLocation, this.getX(), this.getY(), (float)this.getRight(), (float)(this.getBottom() + this.getScrollAmount()), this.width, this.height, 32, 32);
        RenderSystem.disableBlend();
    }

    private void renderListSeparators(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        ResourceLocation headerSeparatorLocation = this.minecraft.level == null ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation footerSeparatorLocation = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        graphics.blit(headerSeparatorLocation, this.getX(), this.getY() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        graphics.blit(footerSeparatorLocation, this.getX(), this.getBottom(), 0.0f, 0.0f, this.width, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    private void renderScrollBar(GuiGraphics graphics) {
        int size = Math.min(this.height, this.height * this.height / this.contentHeight);
        int x = this.getScrollBarPosX();
        double scale = (double)this.scrollAmount / (double)(this.contentHeight - this.height);
        int y = this.getY() + (int)(scale * (double)(this.height - size));
        RenderSystem.enableBlend();
        graphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, x, this.getY(), 6, this.height);
        graphics.blitSprite(SCROLLER_SPRITE, x, y, 6, size);
        RenderSystem.disableBlend();
    }

    protected int getScrollBarPosX() {
        return this.width / 2 + 156;
    }

    public void update() {
        this.entryHeights = new IntArrayList();
        int contentHeight = 0;
        for (Entry child : this.children) {
            this.entryHeights.add(child.getEntryHeight());
            contentHeight += child.getEntryHeight();
        }
        this.contentHeight = Math.max(this.height, contentHeight);
    }

    public void finish() {
        this.update();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = Mth.clamp((int)scrollAmount, (int)0, (int)Math.max(0, this.contentHeight - this.height));
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)this.getRight() && mouseY >= (double)this.getY() && mouseY <= (double)this.getBottom();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int pos;
        if (!this.scrolling && mouseX > (double)(pos = (this.width - this.getX()) / 2 + 156) && mouseX < (double)(pos + 6)) {
            this.scrolling = true;
            return true;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.mouseClicked(mouseX, mouseY, button)) {
            Entry subEntry = this.getFocused();
            if (subEntry != entry && subEntry != null) {
                subEntry.setFocused(null);
            }
            this.setFocused((GuiEventListener)entry);
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount((int)((double)this.scrollAmount - scrollY * 10.0));
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.setScrollAmount(0);
            } else if (mouseY > (double)(this.getY() + this.height)) {
                this.setScrollAmount(this.contentHeight);
            } else {
                int size = Mth.clamp((int)(this.height * this.height / this.contentHeight), (int)0, (int)(this.height - 6));
                double scale = Math.max(1.0, (double)this.contentHeight / (double)(this.height - size));
                this.setScrollAmount(this.getScrollAmount() + (int)(deltaY * scale));
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void setFocused(@Nullable GuiEventListener child) {
        super.setFocused(child);
        int i = this.children.indexOf(child);
        if (i >= 0 && this.minecraft.getLastInputType().isKeyboard()) {
            this.ensureVisible(i);
        }
    }

    protected int getEntryHeightSum(int index) {
        int sum = 0;
        for (int i = 0; i < index; ++i) {
            sum += this.entryHeights.getInt(i);
        }
        return sum;
    }

    protected int getRowTop(int index) {
        return this.getY() + 4 - this.getScrollAmount() + this.getEntryHeightSum(index);
    }

    public int getRowWidth() {
        return 310;
    }

    public void updateSize(int width, HeaderAndFooterLayout headerAndFooterLayout) {
        this.updateSizeAndPosition(width, headerAndFooterLayout.getContentHeight(), headerAndFooterLayout.getHeaderHeight());
    }

    public void updateSizeAndPosition(int width, int height, int y) {
        this.setSize(width, height);
        this.setY(y);
        this.update();
    }

    protected void ensureVisible(int index) {
        int rowTop3;
        int rowTop = this.getRowTop(index);
        int rowTop2 = rowTop - this.getY() - 4 - this.entryHeights.getInt(index);
        if (rowTop2 < 0) {
            this.setScrollAmount(this.getScrollAmount() + rowTop2);
        }
        if ((rowTop3 = this.getY() + this.height - rowTop - this.entryHeights.getInt(index) * 2) < 0) {
            this.setScrollAmount(this.getScrollAmount() - rowTop3);
        }
    }

    protected final Entry getEntryAtPosition(double x, double y) {
        int center = this.getX() + this.width / 2;
        int halfRowWidth = this.getRowWidth() / 2;
        int rowMinX = center - halfRowWidth;
        int rowMaxX = center + halfRowWidth;
        int sum = 0;
        int i = 0;
        while (sum <= Mth.floor((double)(y - (double)this.getY())) + this.scrollAmount) {
            if (i < this.entryHeights.size()) {
                sum += this.entryHeights.getInt(i);
                ++i;
                continue;
            }
            ++i;
            break;
        }
        if (x < (double)this.getScrollBarPosX() && x >= (double)rowMinX && x <= (double)rowMaxX && --i < this.children.size()) {
            return this.children.get(i);
        }
        return null;
    }

    @Nullable
    protected Entry nextEntry(ScreenDirection direction, Predicate<Entry> predicate, @Nullable Entry currentEntry) {
        int i;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case LEFT: 
            case RIGHT: {
                int n = 0;
                break;
            }
            case UP: {
                int n = -1;
                break;
            }
            case DOWN: {
                int n = i = 1;
            }
        }
        if (!this.children.isEmpty() && i != 0) {
            int j = currentEntry == null ? (i > 0 ? 0 : this.children.size() - 1) : this.children.indexOf(currentEntry) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry entry = this.children.get(k);
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.children.isEmpty()) {
            return null;
        }
        if (!(event instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.nextFocusPath(event);
        }
        FocusNavigationEvent.ArrowNavigation arrowNav = (FocusNavigationEvent.ArrowNavigation)event;
        Entry entry = this.getFocused();
        if (arrowNav.direction().getAxis() == ScreenAxis.HORIZONTAL && entry != null) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)entry.nextFocusPath(event));
        }
        int i = -1;
        ScreenDirection navDir = arrowNav.direction();
        if (entry != null) {
            i = entry.children().indexOf(entry.getFocused());
        }
        if (i == -1) {
            switch (navDir) {
                case LEFT: {
                    i = Integer.MAX_VALUE;
                    navDir = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    i = 0;
                    navDir = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        Entry entry2 = entry;
        ComponentPath path = null;
        while (path == null) {
            if ((entry2 = this.nextEntry(navDir, entryx -> !entryx.children().isEmpty(), entry2)) == null) {
                return null;
            }
            path = entry2.getFocusPathAtIndex((FocusNavigationEvent)arrowNav, i);
        }
        return ComponentPath.path((ContainerEventHandler)this, path);
    }

    @Nullable
    public Entry getHovered() {
        return this.hovered;
    }

    public void addCategory(Component component) {
        this.children.add(new CategoryEntry(component));
    }

    public void addButton(AbstractWidget button) {
        this.children.add(new ButtonEntry(this, button));
    }

    public void addButton(AbstractWidget leftButton, AbstractWidget rightButton) {
        this.children.add(new ButtonEntry(this, leftButton, rightButton));
    }

    public abstract class Entry
    implements ContainerEventHandler {
        @Nullable
        private GuiEventListener focused;
        @Nullable
        private NarratableEntry lastNarratable;
        private boolean dragging;

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, float var7);

        public abstract int getEntryHeight();

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean dragging) {
            this.dragging = dragging;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public boolean isFocused() {
            return OkZoomerSelectionList.this.getFocused() == this;
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (focused != null) {
                focused.setFocused(true);
            }
            this.focused = focused;
        }

        @Nullable
        public ComponentPath getFocusPathAtIndex(FocusNavigationEvent event, int index) {
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath path = ((GuiEventListener)this.children().get(Math.min(index, this.children().size() - 1))).nextFocusPath(event);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                int j;
                int i;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                switch (arrowNavigation.direction()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        int n = -1;
                        break;
                    }
                    case RIGHT: {
                        int n = 1;
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        int n = i = 0;
                    }
                }
                if (i == 0) {
                    return null;
                }
                for (int k = j = Mth.clamp((int)(i + this.children().indexOf(this.getFocused())), (int)0, (int)(this.children().size() - 1)); k >= 0 && k < this.children().size(); k += i) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.children().get(k);
                    ComponentPath path = guiEventListener.nextFocusPath(event);
                    if (path == null) continue;
                    return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
                }
            }
            return super.nextFocusPath(event);
        }

        void updateNarration(NarrationElementOutput narrationElementOutput) {
            List<? extends NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narrationData = Screen.findNarratableWidget(list, (NarratableEntry)this.lastNarratable);
            if (narrationData != null) {
                if (narrationData.priority.isTerminal()) {
                    this.lastNarratable = narrationData.entry;
                }
                if (!list.isEmpty()) {
                    narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.object_list", (Object[])new Object[]{narrationData.index + 1, list.size()}));
                    if (narrationData.priority == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
                    }
                }
                narrationData.entry.updateNarration(narrationElementOutput.nest());
            }
        }

        public abstract List<? extends NarratableEntry> narratables();
    }

    class CategoryEntry
    extends Entry {
        private final Component title;

        private CategoryEntry(Component title) {
            this.title = title;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            graphics.fill(x, y + 1, x + rowWidth, y + 19, -1610612736);
            graphics.drawCenteredString(OkZoomerSelectionList.this.minecraft.font, this.title, x + rowWidth / 2, y + 6, -1);
        }

        @Override
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            return null;
        }

        @Override
        public int getEntryHeight() {
            return 20;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(new NarratableEntry(){

                @NotNull
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.add(NarratedElementType.TITLE, CategoryEntry.this.title);
                }
            });
        }
    }

    class ButtonEntry
    extends Entry {
        private final AbstractWidget leftButton;
        private final AbstractWidget rightButton;
        private final int entryHeight;
        private final List<AbstractWidget> buttons;

        public ButtonEntry(OkZoomerSelectionList this$0, AbstractWidget button) {
            button.setWidth(310);
            this.leftButton = button;
            this.rightButton = null;
            this.entryHeight = button.getHeight() + 4;
            this.buttons = List.of(button);
        }

        public ButtonEntry(OkZoomerSelectionList this$0, AbstractWidget leftButton, AbstractWidget rightButton) {
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            this.entryHeight = (rightButton != null ? Math.max(leftButton.getHeight(), rightButton.getHeight()) : leftButton.getHeight()) + 4;
            this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            this.leftButton.setPosition(x, y + 2);
            this.leftButton.render(graphics, mouseX, mouseY, delta);
            if (this.rightButton != null) {
                this.rightButton.setPosition(x + 160, y + 2);
                this.rightButton.render(graphics, mouseX, mouseY, delta);
            }
        }

        @Override
        public int getEntryHeight() {
            return this.entryHeight;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.buttons;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.buttons;
        }
    }
}

