/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.tooltips;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MuteTooltipSupplier
implements ImageButton.TooltipSupplier {
    public static final Component MUTE_UNMUTED = Component.translatable((String)"message.voicechat.mute.disabled");
    public static final Component MUTE_MUTED = Component.translatable((String)"message.voicechat.mute.enabled");
    public static final Component MUTE_DISABLED_PTT = Component.translatable((String)"message.voicechat.mute.disabled_ptt");
    private Screen screen;
    private ClientPlayerStateManager stateManager;
    @Nullable
    private State lastState;

    public MuteTooltipSupplier(Screen screen, ClientPlayerStateManager stateManager) {
        this.screen = screen;
        this.stateManager = stateManager;
    }

    @Override
    public void updateTooltip(ImageButton button) {
        State state = this.getState();
        if (state != this.lastState) {
            this.lastState = state;
            button.setTooltip(Tooltip.create((Component)state.getComponent()));
        }
    }

    public static boolean canMuteMic() {
        return VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
    }

    private State getState() {
        if (!MuteTooltipSupplier.canMuteMic()) {
            return State.DISABLED_PTT;
        }
        if (this.stateManager.isMuted()) {
            return State.MUTED;
        }
        return State.UNMUTED;
    }

    private static enum State {
        UNMUTED(MUTE_UNMUTED),
        MUTED(MUTE_MUTED),
        DISABLED_PTT(MUTE_DISABLED_PTT);

        private final Component component;

        private State(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

