/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dustydecorations.block;

import java.util.List;
import net.mcreator.dustydecorations.procedures.HangingLassoBlockAddedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HangingLassoBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public HangingLassoBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.4f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.dustydecorations.hanging_lasso.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)1.5, (double)1.0, (double)0.5, (double)13.5, (double)4.0, (double)12.5), HangingLassoBlock.box((double)2.5, (double)2.0, (double)1.5, (double)14.5, (double)5.0, (double)13.5), HangingLassoBlock.box((double)7.0, (double)6.0, (double)10.5, (double)9.0, (double)10.0, (double)12.5), HangingLassoBlock.box((double)9.0, (double)4.0, (double)-2.5, (double)11.0, (double)6.0, (double)3.5), HangingLassoBlock.box((double)8.0, (double)3.0, (double)-7.5, (double)10.0, (double)5.0, (double)-1.5), HangingLassoBlock.box((double)7.0, (double)4.0, (double)2.5, (double)9.0, (double)6.0, (double)4.5)});
            case Direction.NORTH -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)2.5, (double)1.0, (double)3.5, (double)14.5, (double)4.0, (double)15.5), HangingLassoBlock.box((double)1.5, (double)2.0, (double)2.5, (double)13.5, (double)5.0, (double)14.5), HangingLassoBlock.box((double)7.0, (double)6.0, (double)3.5, (double)9.0, (double)10.0, (double)5.5), HangingLassoBlock.box((double)5.0, (double)4.0, (double)12.5, (double)7.0, (double)6.0, (double)18.5), HangingLassoBlock.box((double)6.0, (double)3.0, (double)17.5, (double)8.0, (double)5.0, (double)23.5), HangingLassoBlock.box((double)7.0, (double)4.0, (double)11.5, (double)9.0, (double)6.0, (double)13.5)});
            case Direction.EAST -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)0.5, (double)1.0, (double)2.5, (double)12.5, (double)4.0, (double)14.5), HangingLassoBlock.box((double)1.5, (double)2.0, (double)1.5, (double)13.5, (double)5.0, (double)13.5), HangingLassoBlock.box((double)10.5, (double)6.0, (double)7.0, (double)12.5, (double)10.0, (double)9.0), HangingLassoBlock.box((double)-2.5, (double)4.0, (double)5.0, (double)3.5, (double)6.0, (double)7.0), HangingLassoBlock.box((double)-7.5, (double)3.0, (double)6.0, (double)-1.5, (double)5.0, (double)8.0), HangingLassoBlock.box((double)2.5, (double)4.0, (double)7.0, (double)4.5, (double)6.0, (double)9.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)3.5, (double)1.0, (double)1.5, (double)15.5, (double)4.0, (double)13.5), HangingLassoBlock.box((double)2.5, (double)2.0, (double)2.5, (double)14.5, (double)5.0, (double)14.5), HangingLassoBlock.box((double)3.5, (double)6.0, (double)7.0, (double)5.5, (double)10.0, (double)9.0), HangingLassoBlock.box((double)12.5, (double)4.0, (double)9.0, (double)18.5, (double)6.0, (double)11.0), HangingLassoBlock.box((double)17.5, (double)3.0, (double)8.0, (double)23.5, (double)5.0, (double)10.0), HangingLassoBlock.box((double)11.5, (double)4.0, (double)7.0, (double)13.5, (double)6.0, (double)9.0)});
            case Direction.UP -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)2.5, (double)0.5, (double)1.0, (double)14.5, (double)12.5, (double)4.0), HangingLassoBlock.box((double)1.5, (double)1.5, (double)2.0, (double)13.5, (double)13.5, (double)5.0), HangingLassoBlock.box((double)7.0, (double)10.5, (double)6.0, (double)9.0, (double)12.5, (double)10.0), HangingLassoBlock.box((double)5.0, (double)-2.5, (double)4.0, (double)7.0, (double)3.5, (double)6.0), HangingLassoBlock.box((double)6.0, (double)-7.5, (double)3.0, (double)8.0, (double)-1.5, (double)5.0), HangingLassoBlock.box((double)7.0, (double)2.5, (double)4.0, (double)9.0, (double)4.5, (double)6.0)});
            case Direction.DOWN -> Shapes.or((VoxelShape)HangingLassoBlock.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HangingLassoBlock.box((double)2.5, (double)3.5, (double)12.0, (double)14.5, (double)15.5, (double)15.0), HangingLassoBlock.box((double)1.5, (double)2.5, (double)11.0, (double)13.5, (double)14.5, (double)14.0), HangingLassoBlock.box((double)7.0, (double)3.5, (double)6.0, (double)9.0, (double)5.5, (double)10.0), HangingLassoBlock.box((double)5.0, (double)12.5, (double)10.0, (double)7.0, (double)18.5, (double)12.0), HangingLassoBlock.box((double)6.0, (double)17.5, (double)11.0, (double)8.0, (double)23.5, (double)13.0), HangingLassoBlock.box((double)7.0, (double)11.5, (double)10.0, (double)9.0, (double)13.5, (double)12.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        HangingLassoBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }
}

