/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.network.packet;

import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarMenu;
import com.finchy.pipeorgans.network.AllPackets;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public record TrackerBarGUIPacket(String button, BlockPos pos) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, TrackerBarGUIPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecBuilders.nullable((StreamCodec)ByteBufCodecs.stringUtf8((int)256)), TrackerBarGUIPacket::button, (StreamCodec)BlockPos.STREAM_CODEC, TrackerBarGUIPacket::pos, TrackerBarGUIPacket::new);

    public void handle(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (!(player.containerMenu instanceof TrackerBarMenu)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof TrackerBarBlockEntity) {
            TrackerBarBlockEntity be = (TrackerBarBlockEntity)blockEntity;
            if (this.button.equals("play")) {
                be.pressTogglePlayButton();
            } else if (this.button.equals("stop")) {
                be.pressStopButton();
            }
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.TRACKER_BAR_GUI;
    }
}

