/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.network.packet;

import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.network.AllPackets;
import io.netty.buffer.ByteBuf;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public record KBRMidiMessagePacket(int code, int length, byte[] data) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, KBRMidiMessagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, KBRMidiMessagePacket::code, (StreamCodec)ByteBufCodecs.VAR_INT, KBRMidiMessagePacket::length, (StreamCodec)CatnipStreamCodecBuilders.nullable((StreamCodec)ByteBufCodecs.byteArray((int)Integer.MAX_VALUE)), KBRMidiMessagePacket::data, KBRMidiMessagePacket::new);
    public static final int SHORT_CODE = 0;
    public static final int SYSEX_CODE = 1;
    public static final int META_CODE = 2;
    public static final int OTHER_CODE = -1;

    public void handle(ServerPlayer player) {
        KeyboardRelayBlockEntity kbr;
        BlockEntity blockEntity;
        MidiMessage message;
        try {
            message = this.code == 0 ? new MidiShortMessage(this.data, this.length) : (this.code == 1 ? new SysexMessage(this.data, this.length) : new MidiShortMessage(this.data, this.length));
        }
        catch (InvalidMidiDataException e) {
            throw new RuntimeException(e);
        }
        ServerLevel level = (ServerLevel)player.level();
        BlockPos pos = KeyboardRelayBlockEntity.playerUsingKBRPos((Player)player);
        if (pos != null && (blockEntity = level.getBlockEntity(pos)) instanceof KeyboardRelayBlockEntity && (kbr = (KeyboardRelayBlockEntity)blockEntity).isUsedBy((Player)player)) {
            kbr.handleMidiMessage(message);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.MIDI_MESSAGE;
    }

    public static class MidiShortMessage
    extends ShortMessage {
        public MidiShortMessage(byte[] data, int length) throws InvalidMidiDataException {
            super.setMessage(data, length);
        }
    }
}

