/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.midi.server;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.ServerConfig;
import com.finchy.pipeorgans.content.midi.MusicRollItem;
import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherBlockEntity;
import com.finchy.pipeorgans.init.AllBlocks;
import com.simibubi.create.foundation.utility.FilesHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ServerMidiLoader {
    public static final String serverMidiPath = "midi_files/uploaded";
    private Map<String, MidiUploadEntry> activeUploads;
    private final ObjectArrayList<String> deadEntries = ObjectArrayList.of();

    public ServerMidiLoader() {
        this.activeUploads = new HashMap<String, MidiUploadEntry>();
    }

    public void tick() {
        int timeout = ServerConfig.midiIdleTimeout;
        for (String upload : this.activeUploads.keySet()) {
            MidiUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= timeout) continue;
            PipeOrgans.LOGGER.warn(".mid file upload timed out: {}", (Object)upload);
            this.deadEntries.add((Object)upload);
        }
        for (String toRemove : this.deadEntries) {
            this.cancelUpload(toRemove);
        }
        this.deadEntries.clear();
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(ServerPlayer player, String midi, long size, BlockPos pos) {
        String playerPathString = "midi_files/uploaded/" + player.getGameProfile().getName();
        String playerMidiId = player.getGameProfile().getName() + "/" + midi;
        Path playerPath = Paths.get(playerPathString, new String[0]);
        FilesHelper.createFolderIfMissing((Path)playerPath);
        if (!midi.endsWith(".mid")) {
            PipeOrgans.LOGGER.warn("Attempted .mid file upload with non-supported format: {}", (Object)playerMidiId);
            return;
        }
        Path playerMidisPath = Paths.get(serverMidiPath, player.getGameProfile().getName()).toAbsolutePath();
        Path uploadPath = playerMidisPath.resolve(midi).normalize();
        if (!uploadPath.startsWith(playerMidisPath)) {
            PipeOrgans.LOGGER.warn("Attempted .mid file upload with directory escape: {}", (Object)playerMidiId);
            return;
        }
        if (!this.validateMidiSizeOnServer(player, size)) {
            return;
        }
        if (this.activeUploads.containsKey(playerMidiId)) {
            return;
        }
        try {
            long count;
            RollPuncherBlockEntity puncher = this.getPuncher(player.getCommandSenderWorld(), pos);
            if (puncher == null) {
                return;
            }
            Files.deleteIfExists(uploadPath);
            try (Stream<Path> list = Files.list(playerPath);){
                count = list.count();
            }
            if (count >= (long)ServerConfig.maxMidiFiles) {
                Stream<Path> list2 = Files.list(playerPath);
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            OutputStream writer = Files.newOutputStream(uploadPath, new OpenOption[0]);
            this.activeUploads.put(playerMidiId, new MidiUploadEntry(this, writer, size, player.level(), pos));
            puncher.startUpload(midi);
        }
        catch (IOException e) {
            PipeOrgans.LOGGER.error("Exception thrown when starting upload: {}", (Object)playerMidiId);
            e.printStackTrace();
        }
    }

    public void handleWriteRequest(ServerPlayer player, String midi, byte[] data) {
        String playerMidiId = player.getGameProfile().getName() + "/" + midi;
        if (this.activeUploads.containsKey(playerMidiId)) {
            MidiUploadEntry entry = this.activeUploads.get(playerMidiId);
            entry.bytesUploaded += (long)data.length;
            if ((long)data.length > ServerConfig.maxMidiPacketSize) {
                PipeOrgans.LOGGER.warn("Oversized Midi upload packet received: {}", (Object)playerMidiId);
                this.cancelUpload(playerMidiId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                PipeOrgans.LOGGER.warn("Received more data than expected: {}", (Object)playerMidiId);
                this.cancelUpload(playerMidiId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                RollPuncherBlockEntity puncher = this.getPuncher(entry.world, entry.tablePos);
                if (puncher == null) {
                    return;
                }
                puncher.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                puncher.sendUpdate = true;
            }
            catch (IOException e) {
                PipeOrgans.LOGGER.error("Exception thrown when uploading .mid file: {}", (Object)playerMidiId);
                e.printStackTrace();
                this.cancelUpload(playerMidiId);
            }
        }
    }

    private void cancelUpload(String playerMidiId) {
        if (!this.activeUploads.containsKey(playerMidiId)) {
            return;
        }
        MidiUploadEntry entry = this.activeUploads.remove(playerMidiId);
        try {
            entry.stream.close();
            Files.deleteIfExists(Paths.get(serverMidiPath, playerMidiId));
            PipeOrgans.LOGGER.warn("Cancelled .mid file upload: {}", (Object)playerMidiId);
        }
        catch (IOException e) {
            PipeOrgans.LOGGER.error("Exception thrown when cancelling upload: {}", (Object)playerMidiId);
            e.printStackTrace();
        }
        BlockPos pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        RollPuncherBlockEntity puncher = this.getPuncher(entry.world, pos);
        if (puncher != null) {
            puncher.finishUpload();
        }
    }

    public RollPuncherBlockEntity getPuncher(Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof RollPuncherBlockEntity)) {
            return null;
        }
        RollPuncherBlockEntity puncher = (RollPuncherBlockEntity)be;
        return puncher;
    }

    public void handleFinishedUpload(ServerPlayer player, String midi) {
        String playerMidiId = player.getGameProfile().getName() + "/" + midi;
        if (this.activeUploads.containsKey(playerMidiId)) {
            try {
                this.activeUploads.get((Object)playerMidiId).stream.close();
                MidiUploadEntry removed = this.activeUploads.remove(playerMidiId);
                Level world = removed.world;
                BlockPos pos = removed.tablePos;
                PipeOrgans.LOGGER.info("New .mid file uploaded: {}", (Object)playerMidiId);
                if (pos == null) {
                    return;
                }
                BlockState blockState = world.getBlockState(pos);
                if (AllBlocks.ROLL_PUNCHER.get() != blockState.getBlock()) {
                    return;
                }
                RollPuncherBlockEntity puncher = this.getPuncher(world, pos);
                if (puncher == null) {
                    return;
                }
                puncher.finishUpload();
                puncher.inventory.setStackInSlot(1, MusicRollItem.create(midi, player.getGameProfile().getName()));
            }
            catch (IOException e) {
                PipeOrgans.LOGGER.error("Exception thrown when finishing upload: {}", (Object)playerMidiId);
                e.printStackTrace();
            }
        }
    }

    private boolean validateMidiSizeOnServer(ServerPlayer player, long size) {
        long maxFileSize = ServerConfig.midiFileSizeLimit;
        if (size > maxFileSize * 1024L) {
            player.sendSystemMessage((Component)Component.literal((String)"Midi upload too large").append((Component)Component.literal((String)(" (" + size / 1024L + " KB)."))));
            player.sendSystemMessage((Component)Component.literal((String)"Maximum size is").append((Component)Component.literal((String)(" " + maxFileSize + " KB"))));
            return false;
        }
        return true;
    }

    public class MidiUploadEntry {
        public Level world;
        public BlockPos tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public MidiUploadEntry(ServerMidiLoader this$0, OutputStream stream, long totalBytes, Level world, BlockPos tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

