/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.midi.client;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.midi.client.MidiDeviceInputReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class MidiInputDeviceManager {
    protected Receiver activeReceiver = null;
    protected Transmitter activeTransmitter = null;
    protected MidiDevice activeDevice = null;
    private String selectedDeviceName = "";
    private String midiDeviceError = null;

    public MidiInputDeviceManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PipeOrgans.LOGGER.info("Closing selected MIDI device...");
                ExecutorService ex = Executors.newSingleThreadExecutor();
                Future<?> future = ex.submit(() -> MidiInputDeviceManager.this.close());
                try {
                    future.get(10000L, TimeUnit.MILLISECONDS);
                    ex.shutdownNow();
                    ex = null;
                    this.interrupt();
                }
                catch (Exception e) {
                    PipeOrgans.LOGGER.error("Java ran into an error closing the selected MIDI device: {}", (Object)e.getMessage());
                    if (!future.isDone()) {
                        future.cancel(true);
                    }
                    try {
                        ex.shutdownNow();
                        this.interrupt();
                    }
                    catch (Exception e1) {
                        PipeOrgans.LOGGER.error("Failed to stop executor: {}", (Object)e1.getMessage());
                        this.interrupt();
                    }
                }
            }
        });
    }

    public String getActiveDeviceName() {
        if (this.activeDevice != null) {
            return this.activeDevice.getDeviceInfo().getName();
        }
        return "None";
    }

    public boolean isDeviceSelected() {
        return this.selectedDeviceName != null & !this.selectedDeviceName.trim().isEmpty();
    }

    public String getSelectedDeviceName() {
        return this.selectedDeviceName;
    }

    public String getSelectedDeviceError() {
        return this.midiDeviceError;
    }

    public void saveDeviceSelection(MidiDevice device) {
        this.selectedDeviceName = device.getDeviceInfo().getName();
        this.open();
    }

    public List<MidiDevice> getAvailableDevices() {
        List<MidiDevice> devices = new ArrayList<MidiDevice>();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                devices.add(MidiSystem.getMidiDevice(info));
            }
            catch (MidiUnavailableException e) {
                PipeOrgans.LOGGER.warn("Midi Device error. Skipping. Error: {}", (Object)e.getMessage());
            }
        }
        if (!devices.isEmpty()) {
            devices = devices.stream().filter(d -> d.getMaxTransmitters() != 0 && (d.getMaxTransmitters() == -1 || d.getTransmitters().size() < d.getMaxTransmitters())).toList();
        }
        return devices;
    }

    protected void openTransmitter() {
        PipeOrgans.LOGGER.info("Opening MIDI input device: {}", (Object)this.selectedDeviceName);
        for (MidiDevice device : this.getAvailableDevices()) {
            if (!device.getDeviceInfo().getName().equals(this.selectedDeviceName)) continue;
            PipeOrgans.LOGGER.info("Found matching MIDI input device.");
            try {
                if (this.activeDevice != null) {
                    this.activeDevice.close();
                    this.activeReceiver.close();
                    this.activeReceiver = null;
                }
                this.activeDevice = device;
                this.activeDevice.open();
                this.activeTransmitter = device.getTransmitter();
                this.activeReceiver = new MidiDeviceInputReceiver();
                this.activeTransmitter.setReceiver(this.activeReceiver);
                PipeOrgans.LOGGER.info("Successfully opened MIDI input device: {}", (Object)this.selectedDeviceName);
            }
            catch (MidiUnavailableException e) {
                PipeOrgans.LOGGER.error("Failed to open device {}: {}", (Object)this.selectedDeviceName, (Object)e.getMessage());
                this.midiDeviceError = e.getMessage();
                this.close();
            }
        }
    }

    public void open() {
        if (this.isDeviceSelected()) {
            this.openTransmitter();
            return;
        }
        PipeOrgans.LOGGER.error("Error opening MidiInputDeviceManager: no input device selected!");
    }

    public void close() {
        if (this.activeReceiver != null) {
            this.activeReceiver.close();
            this.activeReceiver = null;
        }
        if (this.activeTransmitter != null) {
            this.activeTransmitter.close();
            this.activeTransmitter = null;
        }
        if (this.activeDevice != null) {
            this.activeDevice.close();
            this.activeDevice = null;
        }
    }
}

