/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.data;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.base.BaseBlock;
import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.DoubleExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.QuadrupleExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.SingleExtensionBlock;
import com.finchy.pipeorgans.data.AssetLookup;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockStateGen {

    public static class BaseGenerator
    extends SpecialBlockStateGen {
        protected int getXRotation(BlockState state) {
            return 0;
        }

        protected int getYRotation(BlockState state) {
            return this.horizontalAngle((Direction)state.getValue((Property)BaseBlock.FACING));
        }

        public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
            String wall = (Boolean)state.getValue((Property)BaseBlock.WALL) != false ? "wall" : "floor";
            boolean powered = (Boolean)state.getValue((Property)GenericPipeBlock.POWERED);
            ModelFile model = AssetLookup.partialStandardModel(ctx, prov, wall);
            if (!powered) {
                return model;
            }
            ResourceLocation parentLocation = model.getLocation();
            return ((BlockModelBuilder)prov.models().withExistingParent(parentLocation.getPath() + "_powered", parentLocation)).texture("0", "pipeorgans:block/copper_redstone_plate_powered");
        }
    }

    public static class PipeExtensionGenerator
    extends SpecialBlockStateGen {
        protected int getXRotation(BlockState state) {
            return 0;
        }

        protected int getYRotation(BlockState state) {
            return state.hasProperty((Property)GenericExtensionBlock.FACING) ? this.horizontalAngle((Direction)state.getValue((Property)GenericExtensionBlock.FACING)) : 0;
        }

        public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
            String shape;
            String size = ((EPipeSizes.PipeSize)((Object)state.getValue(GenericExtensionBlock.SIZE))).getSerializedName();
            if (state.hasProperty(SingleExtensionBlock.SHAPE)) {
                shape = ((EExtensionShapes.SingleShape)((Object)state.getValue(SingleExtensionBlock.SHAPE))).getSerializedName();
            } else if (state.hasProperty(DoubleExtensionBlock.SHAPE)) {
                shape = ((EExtensionShapes.DoubleShape)((Object)state.getValue(DoubleExtensionBlock.SHAPE))).getSerializedName();
            } else if (state.hasProperty(QuadrupleExtensionBlock.SHAPE)) {
                shape = ((EExtensionShapes.QuadrupleShape)((Object)state.getValue(QuadrupleExtensionBlock.SHAPE))).getSerializedName();
            } else {
                PipeOrgans.LOGGER.error("Pipe extension {} has no valid shape property", (Object)ctx.getName());
                shape = "";
            }
            return AssetLookup.partialExtensionModel(ctx, prov, size, shape);
        }
    }

    public static class PipeGenerator
    extends SpecialBlockStateGen {
        protected int getXRotation(BlockState state) {
            return 0;
        }

        protected int getYRotation(BlockState state) {
            return this.horizontalAngle((Direction)state.getValue((Property)GenericPipeBlock.FACING));
        }

        public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
            String wall = (Boolean)state.getValue((Property)GenericPipeBlock.WALL) != false ? "wall" : "floor";
            String size = ((EPipeSizes.PipeSize)((Object)state.getValue(GenericPipeBlock.SIZE))).getSerializedName();
            boolean powered = (Boolean)state.getValue((Property)GenericPipeBlock.POWERED);
            ModelFile model = AssetLookup.partialStandardModel(ctx, prov, size, wall);
            if (!powered) {
                return model;
            }
            ResourceLocation parentLocation = model.getLocation();
            return ((BlockModelBuilder)prov.models().withExistingParent(parentLocation.getPath() + "_powered", parentLocation)).texture("0", "pipeorgans:block/copper_redstone_plate_powered");
        }
    }
}

