/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.hauntedWhistle;

import com.finchy.pipeorgans.content.particles.hauntedJet.HauntedJetParticleData;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.DoublePipeBlockEntity;
import com.finchy.pipeorgans.content.pipes.hauntedWhistle.HauntedWhistleSoundInstance;
import com.finchy.pipeorgans.init.AllBlocks;
import com.finchy.pipeorgans.init.AllSoundEvents;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HauntedWhistleBlockEntity
extends DoublePipeBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    protected HauntedWhistleSoundInstance soundInstance;

    public HauntedWhistleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.baseBlock = AllBlocks.HAUNTED_WHISTLE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(EPipeSizes.PipeSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.level.getGameTime() % 8L == 0L;
        Vec3 eyePosition = Minecraft.getInstance().cameraEntity.getEyePosition();
        float maxVolume = (float)Mth.clamp((double)((64.0 - eyePosition.distanceTo(Vec3.atCenterOf((Vec3i)this.worldPosition))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new HauntedWhistleSoundInstance(size, this.worldPosition);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            this.level.playLocalSound(this.worldPosition, (SoundEvent)AllSoundEvents.HAUNTED_CHIFF.get(), SoundSource.RECORDS, maxVolume * 0.6f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }

    @Override
    public void createSteamJet(EPipeSizes.PipeSize size) {
        Direction facing = this.getBlockState().getOptionalValue((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        Vec3 sizeOffset = VecHelper.rotate((Vec3)new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 0.75), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 v = offset.scale((double)0.45f).add(sizeOffset).add(Vec3.atCenterOf((Vec3i)this.worldPosition));
        Vec3 m = offset.subtract(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.75));
        this.level.addParticle((ParticleOptions)new HauntedJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }
}

