/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.QuadrupleExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class QuadruplePipeBlock
extends GenericPipeBlock {
    public QuadruplePipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, 4);
    }

    @Override
    public void incrementSize(Level pLevel, BlockPos pos, boolean playSound) {
        BlockState base = pLevel.getBlockState(pos);
        if (!base.hasProperty((Property)SIZE)) {
            return;
        }
        EPipeSizes.PipeSize size = (EPipeSizes.PipeSize)((Object)base.getValue((Property)SIZE));
        SoundType soundtype = base.getSoundType();
        BlockPos currentPos = pos.above();
        Direction facing = (Direction)base.getValue((Property)FACING);
        float pVolume = (soundtype.getVolume() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
        SoundEvent hitSound = soundtype.getHitSound();
        for (int i = 1; i <= 12; i += 4) {
            BlockState blockState = pLevel.getBlockState(currentPos);
            if (blockState.getBlock() instanceof QuadrupleExtensionBlock) {
                if (blockState.getValue(QuadrupleExtensionBlock.SHAPE) != EExtensionShapes.QuadrupleShape.QUAD && blockState.getValue(QuadrupleExtensionBlock.SHAPE) != EExtensionShapes.QuadrupleShape.QUAD_CONNECTED) {
                    BlockState toSet = (BlockState)blockState.cycle(QuadrupleExtensionBlock.SHAPE);
                    if (((GenericExtensionBlock)((Object)this.extensionBlock.get())).isDirectional()) {
                        toSet = (BlockState)toSet.setValue((Property)FACING, (Comparable)facing);
                    }
                    pLevel.setBlock(currentPos, toSet, 3);
                    if (playSound) {
                        switch ((EExtensionShapes.QuadrupleShape)((Object)blockState.getValue(QuadrupleExtensionBlock.SHAPE))) {
                            case SINGLE: {
                                ++i;
                                break;
                            }
                            case DOUBLE: {
                                i += 2;
                                break;
                            }
                            case TRIPLE: {
                                i += 3;
                            }
                        }
                        float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                        pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.canBeReplaced()) {
                    return;
                }
                BlockState toSet = (BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).defaultBlockState().setValue((Property)SIZE, (Comparable)((Object)size));
                if (((GenericExtensionBlock)((Object)this.extensionBlock.get())).isDirectional()) {
                    toSet = (BlockState)toSet.setValue((Property)FACING, (Comparable)facing);
                }
                pLevel.setBlock(currentPos, toSet, 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                    pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.above();
        }
    }
}

