/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.init.AllPartialModels;
import com.finchy.pipeorgans.init.AllSpriteShifts;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TrackerBarVisual
extends KineticBlockEntityVisual<TrackerBarBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance rotatingModel;
    private final TransformedInstance roller1;
    private final TransformedInstance roller2;
    @Nullable
    private ScrollInstance paper;
    private final Matrix4f baseTransform1 = new Matrix4f();
    private final Matrix4f baseTransform2 = new Matrix4f();
    private final Quaternionf paperRotation;

    public TrackerBarVisual(VisualizationContext context, TrackerBarBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Direction facing = (Direction)this.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction shaft = facing.getClockWise();
        this.rotatingModel = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.TRACKER_BAR_SHAFT)).createInstance();
        this.rotatingModel.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(shaft).setChanged();
        this.roller1 = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.TRACKER_BAR_ROLLER)).createInstance();
        this.roller2 = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.TRACKER_BAR_ROLLER)).createInstance();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.roller1.translate((Vec3i)this.getVisualPosition())).translate(0.0, 0.28125, 0.0)).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)shaft.getStepX(), (float)shaft.getStepY(), (float)shaft.getStepZ()));
        this.baseTransform1.set((Matrix4fc)this.roller1.pose);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.roller2.translate((Vec3i)this.getVisualPosition())).translate((double)((float)facing.getStepX() / 16.0f), -0.34375, (double)((float)facing.getStepZ() / 16.0f))).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)shaft.getStepX(), (float)shaft.getStepY(), (float)shaft.getStepZ()));
        this.baseTransform2.set((Matrix4fc)this.roller2.pose);
        if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
            facing = facing.getOpposite();
        }
        this.paperRotation = new Quaternionf().rotationXYZ(0.0f, facing.toYRot() * ((float)Math.PI / 180), 0.0f);
        this.animateRollers(partialTick);
        this.checkPaper();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animateRollers(ctx.partialTick());
        this.checkPaper();
    }

    private void animateRollers(float partialTicks) {
        float angle = ((TrackerBarBlockEntity)this.blockEntity).getRollerAngle(partialTicks);
        ((TransformedInstance)this.roller1.setTransform((Matrix4fc)this.baseTransform1).rotateY(angle).uncenter()).setChanged();
        ((TransformedInstance)this.roller2.setTransform((Matrix4fc)this.baseTransform2).rotateY(angle).uncenter()).setChanged();
    }

    private void checkPaper() {
        boolean shouldRender = ((TrackerBarBlockEntity)this.blockEntity).midiSequencerBehaviour.isSequenceLoaded();
        if (shouldRender && this.paper == null) {
            this.paper = (ScrollInstance)this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)AllPartialModels.TRACKER_BAR_PAPER)).createInstance();
            this.setupPaper(this.paper);
        } else if (!shouldRender && this.paper != null) {
            this.paper.delete();
            this.paper = null;
        }
    }

    private void setupPaper(ScrollInstance paper) {
        paper.setSpriteShift(AllSpriteShifts.SCROLLING_MUSIC, 1.0f, 0.5f).position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)this.paperRotation).speed(0.0f, ((TrackerBarBlockEntity)this.blockEntity).getScrollSpeed()).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)((KineticBlockEntity)this.blockEntity))).light(this.computePackedLight()).setChanged();
    }

    protected void _delete() {
        this.rotatingModel.delete();
        this.roller1.delete();
        this.roller2.delete();
        if (this.paper != null) {
            this.paper.delete();
        }
    }

    public void update(float partialTick) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
        if (this.paper != null) {
            this.paper.speed(0.0f, ((TrackerBarBlockEntity)this.blockEntity).getScrollSpeed()).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.rotatingModel, this.roller1, this.roller2, this.paper});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.rotatingModel);
        consumer.accept((Instance)this.roller1);
        consumer.accept((Instance)this.roller2);
        if (this.paper != null) {
            consumer.accept((Instance)this.paper);
        }
    }
}

