/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.rollPuncher;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.PipeOrgansClient;
import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherBlockEntity;
import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherMenu;
import com.finchy.pipeorgans.init.AllBlocks;
import com.finchy.pipeorgans.midi.PipeOrgansPaths;
import com.finchy.pipeorgans.midi.client.ClientMidiLoader;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class RollPuncherScreen
extends AbstractSimiContainerScreen<RollPuncherMenu> {
    private ScrollInput midisArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label midisLabel;
    private static final ResourceLocation GUI_TEXTURE = PipeOrgans.asResource("textures/gui/roll_puncher.png");
    private static final int GUI_WIDTH = 214;
    private static final int GUI_HEIGHT = 85;
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;
    private final ItemStack renderedItem = AllBlocks.ROLL_PUNCHER.asStack();
    private List<Rect2i> extraAreas = Collections.emptyList();

    public RollPuncherScreen(RollPuncherMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void init() {
        this.setWindowSize(214, 89 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 8);
        super.init();
        PipeOrgansClient.MIDI_SENDER.refresh();
        List<Component> availableMidis = PipeOrgansClient.MIDI_SENDER.getAvailableMidis();
        int x = this.leftPos;
        int y = this.topPos + 2;
        this.midisLabel = new Label(x + 51, y + 26, CommonComponents.EMPTY).withShadow();
        this.midisLabel.text = CommonComponents.EMPTY;
        if (!availableMidis.isEmpty()) {
            this.midisArea = new SelectionScrollInput(x + 45, y + 21, 139, 18).forOptions(availableMidis).titled(Component.translatable((String)"gui.pipeorgans.roll_puncher.availableMidis")).writingTo(this.midisLabel);
            this.addRenderableWidgets((GuiEventListener[])new AbstractSimiWidget[]{this.midisArea, this.midisLabel});
        }
        this.confirmButton = new IconButton(x + 44, y + 56, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (((RollPuncherMenu)this.menu).canWrite() && this.midisArea != null) {
                ClientMidiLoader midiSender = PipeOrgansClient.MIDI_SENDER;
                this.progress = 0.0f;
                this.chasingProgress = 0.0f;
                this.lastChasingProgress = 0.0f;
                List<Component> availableMidis1 = midiSender.getAvailableMidis();
                Component midi = availableMidis1.get(this.midisArea.getState());
                midiSender.startNewUpload(midi.getString());
            }
        });
        this.folderButton = new IconButton(x + 20, y + 21, (ScreenElement)AllIcons.I_OPEN_FOLDER);
        this.folderButton.withCallback(() -> Util.getPlatform().openFile(PipeOrgansPaths.MIDIS_DIR.toFile()));
        this.folderButton.setToolTip((Component)Component.translatable((String)"gui.pipeorgans.roll_puncher.open_folder"));
        this.refreshButton = new IconButton(x + 206, y + 21, (ScreenElement)AllIcons.I_REFRESH);
        this.refreshButton.withCallback(() -> {
            ClientMidiLoader midiSender = PipeOrgansClient.MIDI_SENDER;
            midiSender.refresh();
            List<Component> availableMidis1 = midiSender.getAvailableMidis();
            this.removeWidget((GuiEventListener)this.midisArea);
            if (!availableMidis1.isEmpty()) {
                this.midisArea = new SelectionScrollInput(this.leftPos + 45, this.topPos + 21, 139, 18).forOptions(availableMidis1).titled(Component.translatable((String)"gui.pipeorgans.roll_puncher.availableMidis")).writingTo(this.midisLabel);
                this.midisArea.onChanged();
                this.addRenderableWidget((GuiEventListener)this.midisArea);
            } else {
                this.midisArea = null;
                this.midisLabel.text = CommonComponents.EMPTY;
            }
        });
        this.refreshButton.setToolTip((Component)Component.translatable((String)"gui.pipeorgans.roll_puncher.refresh"));
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.confirmButton, this.folderButton, this.refreshButton});
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + 214, y + 85 - 40, 48, 48), (Object)new Rect2i(this.refreshButton.getX(), this.refreshButton.getY(), this.refreshButton.getWidth(), this.refreshButton.getHeight()));
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + 85 + 4;
        this.renderPlayerInventory(pGuiGraphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        pGuiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        Object titleText = ((RollPuncherBlockEntity)((Object)((RollPuncherMenu)this.menu).contentHolder)).isUploading ? Component.translatable((String)"gui.pipeorgans.roll_puncher.uploading") : (((RollPuncherMenu)this.menu).getSlot(1).hasItem() ? Component.translatable((String)"gui.pipeorgans.roll_puncher.finished") : this.title);
        pGuiGraphics.drawString(this.font, (Component)titleText, x + (206 - this.font.width((FormattedText)titleText)) / 2, y + 4, 0x505050, false);
        if (this.midisArea == null) {
            pGuiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pipeorgans.roll_puncher.noMidis"), x + 54, y + 26, 0xD3D3D3);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + 214), (float)(y + 85 - 40), -200.0f)).scale(3.0).render(pGuiGraphics);
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getWidth() * Mth.lerp((float)pPartialTick, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getHeight();
        pGuiGraphics.blit(AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.location, x + 70, y + 59, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartX(), AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartY(), width, height);
    }

    protected void containerTick() {
        super.containerTick();
        boolean finished = ((RollPuncherMenu)this.menu).getSlot(1).hasItem();
        if (((RollPuncherBlockEntity)((Object)((RollPuncherMenu)this.menu).contentHolder)).isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((RollPuncherBlockEntity)((Object)((RollPuncherMenu)this.menu).contentHolder)).uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.active = false;
            if (this.midisLabel != null) {
                this.midisLabel.colored(0xCCDDFF);
                String uploadingMidi = ((RollPuncherBlockEntity)((Object)((RollPuncherMenu)this.menu).contentHolder)).uploadingMidi;
                this.midisLabel.text = uploadingMidi == null ? null : Component.literal((String)uploadingMidi);
            }
            if (this.midisArea != null) {
                this.midisArea.visible = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.active = true;
            if (this.midisLabel != null) {
                this.midisLabel.colored(0xFFFFFF);
            }
            if (this.midisArea != null) {
                this.midisArea.writingTo(this.midisLabel);
                this.midisArea.visible = true;
            }
        }
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

