/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.rollPuncher;

import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherMenu;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class RollPuncherBlockEntity
extends SmartBlockEntity
implements MenuProvider,
IInteractionChecker {
    public RollPuncherInventory inventory = new RollPuncherInventory();
    public boolean isUploading;
    public String uploadingMidi = null;
    public float uploadingProgress = 0.0f;
    public boolean sendUpdate;

    public RollPuncherBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        super.read(tag, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (tag.contains("Uploading")) {
            this.isUploading = true;
            this.uploadingMidi = tag.getString("Midi");
            this.uploadingProgress = tag.getFloat("Progress");
        } else {
            this.isUploading = false;
            this.uploadingMidi = null;
            this.uploadingProgress = 0.0f;
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        super.write(tag, registries, clientPacket);
        if (clientPacket && this.isUploading) {
            tag.putBoolean("Uploading", true);
            tag.putString("Midi", this.uploadingMidi);
            tag.putFloat("Progress", this.uploadingProgress);
        }
    }

    public void tick() {
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
        }
    }

    public void startUpload(String midi) {
        this.isUploading = true;
        this.uploadingProgress = 0.0f;
        this.uploadingMidi = midi;
        this.sendUpdate = true;
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void finishUpload() {
        this.isUploading = false;
        this.uploadingProgress = 0.0f;
        this.uploadingMidi = null;
        this.sendUpdate = true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return RollPuncherMenu.create(pContainerId, pPlayerInventory, this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.pipeorgans.roll_puncher.title");
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public class RollPuncherInventory
    extends ItemStackHandler {
        public RollPuncherInventory() {
            super(2);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            RollPuncherBlockEntity.this.setChanged();
        }
    }
}

