/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.rollPuncher;

import com.finchy.pipeorgans.content.midi.rollPuncher.RollPuncherBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class RollPuncherBlock
extends HorizontalDirectionalBlock
implements IBE<RollPuncherBlockEntity> {
    public static final MapCodec<RollPuncherBlock> CODEC = RollPuncherBlock.simpleCodec(RollPuncherBlock::new);

    public RollPuncherBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
        super.createBlockStateDefinition(pBuilder);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.ROLL_PUNCHER_COLLISION_BOX.get((Direction)pState.getValue((Property)FACING));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.ROLL_PUNCHER_HITBOX.get((Direction)pState.getValue((Property)FACING));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> pPlayer.openMenu((MenuProvider)be, arg_0 -> ((RollPuncherBlockEntity)((Object)be)).sendToMenu(arg_0)));
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.hasBlockEntity() || pState.getBlock() == pNewState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> ItemHelper.dropContents((Level)pLevel, (BlockPos)pPos, (IItemHandler)be.inventory));
        pLevel.removeBlockEntity(pPos);
    }

    public Class<RollPuncherBlockEntity> getBlockEntityClass() {
        return RollPuncherBlockEntity.class;
    }

    public BlockEntityType<? extends RollPuncherBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.ROLL_PUNCHER_BLOCK_ENTITY.get();
    }
}

