/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.keyboardRelay;

import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.init.AllMenuTypes;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class KeyboardRelayMenu
extends GhostItemMenu<KeyboardRelayBlockEntity> {
    public KeyboardRelayMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public KeyboardRelayMenu(MenuType<?> type, int id, Inventory inv, KeyboardRelayBlockEntity be) {
        super(type, id, inv, (Object)be);
    }

    protected ItemStackHandler createGhostInventory() {
        return ((KeyboardRelayBlockEntity)((Object)this.contentHolder)).midiSourceBehaviour.storedGhostInv;
    }

    protected boolean allowRepeats() {
        return true;
    }

    public static KeyboardRelayMenu create(int id, Inventory inv, KeyboardRelayBlockEntity be) {
        return new KeyboardRelayMenu((MenuType)AllMenuTypes.KEYBOARD_RELAY_MENU.get(), id, inv, be);
    }

    protected KeyboardRelayBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof KeyboardRelayBlockEntity) {
            KeyboardRelayBlockEntity kbr = (KeyboardRelayBlockEntity)blockEntity;
            kbr.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return kbr;
        }
        return null;
    }

    protected void saveData(KeyboardRelayBlockEntity contentHolder) {
        contentHolder.midiSourceBehaviour.storedGhostInv = this.ghostInventory;
    }

    protected void addSlots() {
        this.addPlayerSlots(12, 161);
        int x = 31;
        int y = 24;
        int slot = 0;
        for (int column = 0; column < 4; ++column) {
            for (int row = 0; row < 4; ++row) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, slot++, column * 42 + x, row * 20 + y));
            }
        }
    }
}

