/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi;

import com.finchy.pipeorgans.content.midi.RedstoneMidiTransmitter;
import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlock;
import com.finchy.pipeorgans.util.MidiUtils;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import javax.sound.midi.ShortMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MidiSourceBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<MidiSourceBehaviour> TYPE = new BehaviourType();
    public ItemStackHandler storedGhostInv;
    public RedstoneMidiTransmitter link;
    protected Level level;
    protected BlockPos pos;

    public MidiSourceBehaviour(SmartBlockEntity be) {
        super(be);
        this.level = be.getLevel();
        this.pos = be.getBlockPos();
        this.storedGhostInv = new ItemStackHandler(16){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MidiSourceBehaviour.this.blockEntity.setChanged();
                if (!MidiSourceBehaviour.this.blockEntity.getLevel().isClientSide()) {
                    MidiSourceBehaviour.this.link.changeFrequencyKey(slot, this.getStackInSlot(slot));
                }
            }
        };
        this.link = new RedstoneMidiTransmitter((BlockEntity)be);
        this.link.setFrequencyKeysOnLoad(this.storedGhostInv);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.put("frequencyItems", (Tag)this.storedGhostInv.serializeNBT(registries));
    }

    public void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.storedGhostInv.deserializeNBT(registries, tag.getCompound("frequencyItems"));
        this.link.setFrequencyKeysOnLoad(this.storedGhostInv);
    }

    public void handleNote(ShortMessage sm) {
        if (MidiUtils.isNoteOn(sm)) {
            if (!this.link.areNotesActive()) {
                this.reactToNote(true);
            }
            this.link.activateNote(sm.getChannel(), sm.getData1(), sm.getData2());
        } else {
            this.link.deactivateNote(sm.getChannel(), sm.getData1());
            if (!this.link.areNotesActive()) {
                this.reactToNote(false);
            }
        }
    }

    public void reactToNote(boolean on) {
        BlockState state = this.blockEntity.getBlockState();
        state = (BlockState)state.setValue((Property)KeyboardRelayBlock.TRANSMITTING, (Comparable)Boolean.valueOf(on));
        this.blockEntity.getLevel().setBlock(this.pos, state, 3);
    }
}

