/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client.gui.screens.settings;

import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.WorldPreviewConfig;
import caeruleustait.world.preview.backend.storage.PreviewStorageCacheManager;
import caeruleustait.world.preview.client.WorldPreviewComponents;
import caeruleustait.world.preview.client.gui.widgets.WGLabel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;

public class CacheTab
extends GridLayoutTab {
    private final PreviewStorageCacheManager cacheManager;

    public CacheTab(Minecraft minecraft, PreviewStorageCacheManager cacheManager) {
        super(WorldPreviewComponents.SETTINGS_CACHE_TITLE);
        this.cacheManager = cacheManager;
        WorldPreviewConfig cfg = WorldPreview.get().cfg();
        int LINE_WIDTH = 320;
        Checkbox cbGameEnable = Checkbox.builder((Component)WorldPreviewComponents.SETTINGS_CACHE_G_ENABLE, (Font)minecraft.font).selected(cfg.cacheInGame).onValueChange((box, val) -> {
            cfg.cacheInGame = val;
        }).build();
        Checkbox cbNewEnable = Checkbox.builder((Component)WorldPreviewComponents.SETTINGS_CACHE_N_ENABLE, (Font)minecraft.font).selected(cfg.cacheInNew).onValueChange((box, val) -> {
            cfg.cacheInNew = val;
        }).build();
        Checkbox cbCompressEnable = Checkbox.builder((Component)WorldPreviewComponents.SETTINGS_CACHE_COMPRESSION, (Font)minecraft.font).selected(cfg.enableCompression).onValueChange((box, val) -> {
            cfg.enableCompression = val;
        }).build();
        cbCompressEnable.setTooltip(Tooltip.create((Component)WorldPreviewComponents.SETTINGS_CACHE_COMPRESSION_TOOLTIP));
        Button btnClear = Button.builder((Component)WorldPreviewComponents.SETTINGS_CACHE_CLEAR, this::onClearCache).tooltip(Tooltip.create((Component)WorldPreviewComponents.SETTINGS_CACHE_CLEAR_TOOLTIP)).width(320).build();
        GridLayout.RowHelper rowHelper = this.layout.rowSpacing(8).createRowHelper(1);
        rowHelper.addChild((LayoutElement)new WGLabel(minecraft.font, 0, 0, 320, 20, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_CACHE_DESC, 0xFFFFFF));
        rowHelper.addChild((LayoutElement)cbGameEnable);
        rowHelper.addChild((LayoutElement)cbNewEnable);
        rowHelper.addChild((LayoutElement)new WGLabel(minecraft.font, 0, 0, 320, 20, WGLabel.TextAlignment.CENTER, (Component)Component.empty(), 0xFFFFFF));
        rowHelper.addChild((LayoutElement)btnClear);
        rowHelper.addChild((LayoutElement)new WGLabel(minecraft.font, 0, 0, 320, 20, WGLabel.TextAlignment.CENTER, (Component)Component.empty(), 0xFFFFFF));
        rowHelper.addChild((LayoutElement)new WGLabel(minecraft.font, 0, 0, 320, 20, WGLabel.TextAlignment.CENTER, (Component)Component.empty(), 0xFFFFFF));
        rowHelper.addChild((LayoutElement)cbCompressEnable);
    }

    private void onClearCache(Button btn) {
        this.cacheManager.clearCache();
    }
}

