/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client.gui.screens;

import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.color.PreviewMappingData;
import caeruleustait.world.preview.client.WorldPreviewComponents;
import caeruleustait.world.preview.client.gui.screens.PreviewContainer;
import caeruleustait.world.preview.client.gui.screens.settings.BiomesTab;
import caeruleustait.world.preview.client.gui.screens.settings.CacheTab;
import caeruleustait.world.preview.client.gui.screens.settings.DimensionsTab;
import caeruleustait.world.preview.client.gui.screens.settings.GeneralTab;
import caeruleustait.world.preview.client.gui.screens.settings.HeightmapTab;
import caeruleustait.world.preview.client.gui.screens.settings.SamplingTab;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SettingsScreen
extends Screen {
    public static final ResourceLocation HEADER_SEPERATOR = ResourceLocation.parse((String)"textures/gui/header_separator.png");
    public static final ResourceLocation FOOTER_SEPERATOR = ResourceLocation.parse((String)"textures/gui/footer_separator.png");
    public static final ResourceLocation LIGHT_DIRT_BACKGROUND = ResourceLocation.parse((String)"textures/gui/light_dirt_background.png");
    private final Screen lastScreen;
    private final PreviewContainer previewContainer;
    private TabManager tabManager;
    private TabNavigationBar tabNavigationBar;
    private GridLayout bottomButtons;

    public SettingsScreen(Screen lastScreen, PreviewContainer previewContainer) {
        super(WorldPreviewComponents.SETTINGS_TITLE);
        this.lastScreen = lastScreen;
        this.previewContainer = previewContainer;
        this.tabManager = new TabManager(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    }

    protected void init() {
        this.tabNavigationBar = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(new Tab[]{new GeneralTab(this.minecraft), new CacheTab(this.minecraft, this.previewContainer.dataProvider()), new SamplingTab(this.minecraft), new HeightmapTab(this.minecraft, this.previewContainer.previewData()), new DimensionsTab(this.minecraft, this.previewContainer.levelStemKeys()), new BiomesTab(this.minecraft, this.previewContainer)}).build();
        this.tabNavigationBar.selectTab(0, false);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.bottomButtons = new GridLayout().columnSpacing(10);
        GridLayout.RowHelper rowHelper = this.bottomButtons.createRowHelper(1);
        rowHelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.onClose()).build());
        this.bottomButtons.visitWidgets(abstractWidget -> {
            abstractWidget.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)abstractWidget);
        });
        this.repositionElements();
    }

    public void repositionElements() {
        if (this.tabNavigationBar != null) {
            this.tabNavigationBar.setWidth(this.width);
            this.tabNavigationBar.arrangeElements();
            this.bottomButtons.arrangeElements();
            FrameLayout.centerInRectangle((LayoutElement)this.bottomButtons, (int)0, (int)(this.height - 36), (int)this.width, (int)36);
            int i = this.tabNavigationBar.getRectangle().bottom();
            ScreenRectangle screenRectangle = new ScreenRectangle(0, i, this.width, this.bottomButtons.getY() - i);
            this.tabManager.setTabArea(screenRectangle);
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.blit(FOOTER_SEPERATOR, 0, Mth.roundToward((int)(this.height - 36 - 2), (int)2), 0.0f, 0.0f, this.width, 2, 32, 2);
        super.render(guiGraphics, i, j, f);
    }

    public void onClose() {
        Map<ResourceLocation, PreviewMappingData.ColorEntry> toWrite = this.previewContainer.allBiomes().stream().filter(x -> x.dataSource() == PreviewData.DataSource.CONFIG).collect(Collectors.toMap(x -> x.entry().key().location(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.CONFIG, x.color(), x.isCave(), x.name())));
        WorldPreview.get().writeUserColorConfig(toWrite);
        this.previewContainer.patchColorData();
        this.previewContainer.resetTabs();
        this.minecraft.setScreen(this.lastScreen);
    }
}

