/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.apache.commons.lang3.StringUtils;

public class WorldPreviewClient {
    public static ShaderInstance HSV_SHADER;

    public static void renderTexture(AbstractTexture texture, double xMin, double yMin, double xMax, double yMax) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (int)texture.getId());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.addVertex((float)xMin, (float)yMax, 0.0f).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex((float)xMax, (float)yMax, 0.0f).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex((float)xMax, (float)yMin, 0.0f).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex((float)xMin, (float)yMin, 0.0f).setUv(0.0f, 0.0f);
        try (MeshData data = bufferBuilder.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    public static String toTitleCase(String input) {
        if (input == null || input.isBlank()) {
            return input;
        }
        return Arrays.stream(input.split(" ")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="world_preview")
    public static class ModClientEvents {
        @SubscribeEvent
        public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.parse((String)"world_preview:hsv"), DefaultVertexFormat.NEW_ENTITY), shaderInstance -> {
                HSV_SHADER = shaderInstance;
            });
        }
    }
}

