/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.worker;

import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.storage.PreviewSection;
import caeruleustait.world.preview.backend.worker.WorkResult;
import caeruleustait.world.preview.backend.worker.WorkUnit;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WorkBatch {
    public final List<WorkUnit> workUnits;
    private final Object completedSynchro;
    private final PreviewData previewData;
    private boolean isCanceled = false;

    public WorkBatch(List<WorkUnit> workUnits, Object completedSynchro, PreviewData previewData) {
        this.workUnits = workUnits;
        this.completedSynchro = completedSynchro;
        this.previewData = previewData;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel() {
        this.isCanceled = true;
        this.workUnits.forEach(WorkUnit::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            if (this.isCanceled()) {
                return;
            }
            ArrayList<WorkResult> res = new ArrayList<WorkResult>();
            for (WorkUnit unit : this.workUnits) {
                res.addAll(unit.work());
                if (!this.isCanceled()) continue;
                return;
            }
            Object object = this.completedSynchro;
            synchronized (object) {
                this.workUnits.forEach(WorkUnit::markCompleted);
            }
            this.applyChunkResult(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void applyChunkResult(List<WorkResult> workResultList) {
        try {
            for (WorkResult workResult : workResultList) {
                if (workResult == null) {
                    return;
                }
                ChunkPos chunkPos = workResult.workUnit().chunk();
                int qStartX = QuartPos.fromSection((int)chunkPos.x);
                int qStartZ = QuartPos.fromSection((int)chunkPos.z);
                PreviewSection section = workResult.section();
                PreviewSection.AccessData offsetData = section.calcQuartOffsetData(qStartX, qStartZ, qStartX + 4, qStartZ + 4);
                for (WorkResult.BlockResult blockResult : workResult.results()) {
                    section.set(offsetData.minX() + blockResult.quartX() - qStartX, offsetData.minZ() + blockResult.quartZ() - qStartZ, blockResult.value());
                }
                for (Pair pair : workResult.structures()) {
                    StructureStart structureStart = (StructureStart)pair.getSecond();
                    short id = this.previewData.struct2Id().getShort((Object)((ResourceLocation)pair.getFirst()).toString());
                    section.addStructure(new PreviewSection.PreviewStruct(structureStart.getBoundingBox().getCenter(), id, structureStart.getBoundingBox()));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

