/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.color;

import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.backend.color.BaseMultiJsonResourceReloadListener;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.color.PreviewMappingData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class StructureMapReloadListener
extends BaseMultiJsonResourceReloadListener {
    public StructureMapReloadListener() {
        super("structure_icons.json");
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        WorldPreview worldPreview = WorldPreview.get();
        PreviewMappingData previewMappingData = worldPreview.biomeColorMap();
        previewMappingData.clearStructures();
        WorldPreview.LOGGER.debug("Loading structure resource entries");
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : object.entrySet()) {
            WorldPreview.LOGGER.debug(" - loading entries from {}", (Object)entry.getKey());
            for (JsonElement jsonElement : entry.getValue()) {
                Map<ResourceLocation, PreviewMappingData.StructureEntry> curr = StructureMapReloadListener.parseStructureData(entry.getKey().getNamespace(), jsonElement, PreviewData.DataSource.RESOURCE);
                previewMappingData.updateStruct(curr);
            }
        }
    }

    public static Map<ResourceLocation, PreviewMappingData.StructureEntry> parseStructureData(String namespace, JsonElement jsonElement, PreviewData.DataSource dataSource) {
        HashMap<ResourceLocation, PreviewMappingData.StructureEntry> res = new HashMap<ResourceLocation, PreviewMappingData.StructureEntry>();
        JsonObject obj = jsonElement.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            ResourceLocation location = ResourceLocation.parse((String)((String)entry.getKey()));
            PreviewMappingData.StructureEntry value = new PreviewMappingData.StructureEntry();
            JsonElement rawEl = (JsonElement)entry.getValue();
            value.dataSource = dataSource;
            try {
                if (rawEl.isJsonPrimitive()) {
                    if (rawEl.getAsString().equals("hidden")) continue;
                    value.item = rawEl.getAsString();
                } else {
                    JsonObject raw = rawEl.getAsJsonObject();
                    JsonElement nameEl = raw.get("name");
                    JsonElement itemEl = raw.get("item");
                    JsonElement iconEl = raw.get("icon");
                    JsonElement textureEl = raw.get("texture");
                    String string = value.name = nameEl == null ? null : nameEl.getAsString();
                    if (textureEl == null) {
                        textureEl = iconEl;
                    }
                    if (textureEl != null) {
                        value.texture = textureEl.getAsString();
                    } else if (itemEl != null) {
                        if (itemEl.getAsString().equals("hidden")) continue;
                        value.item = itemEl.getAsString();
                    } else {
                        value.texture = "world_preview:textures/structure/unknown.png";
                    }
                }
            }
            catch (IllegalStateException | NullPointerException | UnsupportedOperationException e) {
                WorldPreview.LOGGER.warn("   - {}: Invalid structure entry format: {}", (Object)location, (Object)e.getMessage());
                continue;
            }
            WorldPreview.LOGGER.debug("   - {}: {} - {}", new Object[]{location, value.name, value.texture});
            res.put(location, value);
        }
        return res;
    }
}

