/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.color;

import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.color.PreviewMappingData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class HeightmapPresetReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();

    public HeightmapPresetReloadListener() {
        super(GSON, "heightmap_preview_presets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        WorldPreview worldPreview = WorldPreview.get();
        PreviewMappingData previewMappingData = worldPreview.biomeColorMap();
        previewMappingData.clearHeightmapPresets();
        WorldPreview.LOGGER.debug("Loading heightmap presets:");
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            PreviewData.HeightmapPresetData value = (PreviewData.HeightmapPresetData)GSON.fromJson(entry.getValue(), PreviewData.HeightmapPresetData.class);
            WorldPreview.LOGGER.debug(" - {}: {} | {} to {}", new Object[]{entry.getKey(), value.name(), value.minY(), value.maxY()});
            previewMappingData.addHeightmapPreset(value);
        }
    }
}

