/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillagerPackResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VillagerAPI");

    public static DiscoveryResult discoverAndProcessPacks(List<PackFilter> requiredFilters, Consumer<VillagerPackLoader.VillagerPack> packConsumer) {
        Path villagerPacksDir = CommonPlatformHelper.getGameDirectory().resolve("villagerpacks");
        if (!Files.exists(villagerPacksDir, new LinkOption[0])) {
            LOGGER.debug("No villagerpacks directory found at: {}", (Object)villagerPacksDir);
            return new DiscoveryResult(List.of(), 0);
        }
        ArrayList<Path> validPacks = new ArrayList<Path>();
        int skipped = 0;
        try (Stream<Path> packs = Files.list(villagerPacksDir);){
            List<Path> allPacks = packs.filter(path -> Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")).toList();
            for (Path packPath : allPacks) {
                try (VillagerPackLoader.VillagerPack pack = new VillagerPackLoader.VillagerPack(packPath);){
                    boolean passesAllFilters = true;
                    for (PackFilter filter : requiredFilters) {
                        if (filter.test(pack)) continue;
                        LOGGER.debug("Skipping '{}' - missing {}", (Object)pack.getName(), (Object)filter.getDescription());
                        passesAllFilters = false;
                        break;
                    }
                    if (passesAllFilters) {
                        validPacks.add(packPath);
                        packConsumer.accept(pack);
                        continue;
                    }
                    ++skipped;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to process villagerpack: {}", (Object)packPath.getFileName(), (Object)e);
                    ++skipped;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to list villagerpacks directory", (Throwable)e);
        }
        return new DiscoveryResult(validPacks, skipped);
    }

    public static DiscoveryResult discoverResourcePacks(Consumer<VillagerPackLoader.VillagerPack> packConsumer) {
        return VillagerPackResourceManager.discoverAndProcessPacks(List.of(PackFilter.HAS_CONFIG, PackFilter.HAS_ASSETS), packConsumer);
    }

    public static DiscoveryResult discoverDataPacks(Consumer<VillagerPackLoader.VillagerPack> packConsumer) {
        return VillagerPackResourceManager.discoverAndProcessPacks(List.of(PackFilter.HAS_CONFIG, PackFilter.HAS_DATA), packConsumer);
    }

    public static DiscoveryResult discoverAllPacks(Consumer<VillagerPackLoader.VillagerPack> packConsumer) {
        return VillagerPackResourceManager.discoverAndProcessPacks(List.of(PackFilter.HAS_CONFIG), packConsumer);
    }

    public static class DiscoveryResult {
        private final List<Path> packPaths;
        private final int skippedCount;

        public DiscoveryResult(List<Path> packPaths, int skippedCount) {
            this.packPaths = packPaths;
            this.skippedCount = skippedCount;
        }

        public List<Path> getPackPaths() {
            return this.packPaths;
        }

        public int getSkippedCount() {
            return this.skippedCount;
        }

        public int getFoundCount() {
            return this.packPaths.size();
        }
    }

    public static enum PackFilter {
        HAS_ASSETS(VillagerPackLoader.VillagerPack::hasAssets, "assets"),
        HAS_DATA(VillagerPackLoader.VillagerPack::hasData, "data"),
        HAS_CONFIG(VillagerPackLoader.VillagerPack::hasConfig, "config");

        private final Predicate<VillagerPackLoader.VillagerPack> predicate;
        private final String description;

        private PackFilter(Predicate<VillagerPackLoader.VillagerPack> predicate, String description) {
            this.predicate = predicate;
            this.description = description;
        }

        public boolean test(VillagerPackLoader.VillagerPack pack) {
            return this.predicate.test(pack);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

