/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.RegistryHelper;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;

public class VAPIProfessions {
    private static final RegistryHelper.DynamicRegistry<VillagerProfession> PROFESSIONS = new RegistryHelper.DynamicRegistry("professions");

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.ProfessionData profData = VillagerPackCodecs.parseProfession(json);
            String registryName = RegistryHelper.sanitizeRegistryName(name);
            String namespace = RegistryHelper.getNamespace(json, "villagerapi");
            Supplier<VillagerProfession> profession = CommonPlatformHelper.registerProfession(namespace, registryName, () -> VAPIProfessions.createProfession(registryName, profData));
            PROFESSIONS.register(name, profession);
            VillagerAPI.LOGGER.info("Registered profession from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register profession from pack: {}", (Object)name, (Object)e);
        }
    }

    private static VillagerProfession createProfession(String registryName, VillagerPackCodecs.ProfessionData profData) {
        Supplier<PoiType> poiTypeSupplier = VAPIPoiTypes.getDynamicPoiType(profData.poiType());
        if (poiTypeSupplier == null) {
            VillagerAPI.LOGGER.warn("POI type {} not found for profession {}. Profession will not function.", (Object)profData.poiType(), (Object)registryName);
            return VAPIProfessions.createInactiveProfession(registryName);
        }
        SoundEvent workSound = VAPIProfessions.getWorkSound(profData.workSound(), registryName);
        return new VillagerProfession(registryName, holder -> ((PoiType)holder.value()).equals(poiTypeSupplier.get()), holder -> ((PoiType)holder.value()).equals(poiTypeSupplier.get()), ImmutableSet.of(), ImmutableSet.of(), workSound);
    }

    private static VillagerProfession createInactiveProfession(String registryName) {
        return new VillagerProfession(registryName, holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_ARMORER);
    }

    private static SoundEvent getWorkSound(ResourceLocation soundId, String professionName) {
        SoundEvent workSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundId);
        if (workSound == null) {
            VillagerAPI.LOGGER.warn("Sound event {} not found for profession {}, using default", (Object)soundId, (Object)professionName);
            return SoundEvents.VILLAGER_WORK_ARMORER;
        }
        return workSound;
    }

    public static void validateProfessions() {
        int valid = 0;
        int invalid = 0;
        for (String name : PROFESSIONS.getAll().keySet()) {
            Supplier<VillagerProfession> supplier;
            if (RegistryHelper.validateEntry(name, supplier = PROFESSIONS.get(name), "Profession validation", VillagerAPI.LOGGER)) {
                ++valid;
                continue;
            }
            ++invalid;
        }
        if (valid > 0 || invalid > 0) {
            VillagerAPI.LOGGER.info("Profession validation: {} valid, {} invalid", (Object)valid, (Object)invalid);
        }
    }

    public static Supplier<VillagerProfession> getDynamicProfession(String name) {
        return PROFESSIONS.get(name);
    }

    public static Map<String, Supplier<VillagerProfession>> getDynamicProfessions() {
        return PROFESSIONS.getAll();
    }
}

