/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RegistryHelper {
    public static void registerFromPacks(Map<String, JsonObject> data, String registryName, BiConsumer<String, JsonObject> registrar, Logger logger) {
        if (data == null || data.isEmpty()) {
            return;
        }
        logger.info("Registering {} {} from packs", (Object)data.size(), (Object)registryName);
        int succeeded = 0;
        int failed = 0;
        for (Map.Entry<String, JsonObject> entry : data.entrySet()) {
            String name = entry.getKey();
            try {
                registrar.accept(name, entry.getValue());
                ++succeeded;
            }
            catch (Exception e) {
                ++failed;
                logger.error("Failed to register {} '{}': {}", new Object[]{registryName, name, e.getMessage(), e});
            }
        }
        if (failed > 0) {
            logger.warn("Registration summary for {}: {} succeeded, {} failed", new Object[]{registryName, succeeded, failed});
        }
    }

    public static String sanitizeRegistryName(String name) {
        return name.replace("/", "_");
    }

    public static String getNamespace(JsonObject json, String fallback) {
        return json.has("namespace") ? json.get("namespace").getAsString() : fallback;
    }

    public static <T> boolean validateEntry(String entryName, Supplier<T> supplier, String context, Logger logger) {
        if (supplier == null) {
            logger.warn("{}: Entry '{}' not found", (Object)context, (Object)entryName);
            return false;
        }
        try {
            T value = supplier.get();
            if (value == null) {
                logger.warn("{}: Entry '{}' resolved to null", (Object)context, (Object)entryName);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("{}: Failed to resolve entry '{}': {}", new Object[]{context, entryName, e.getMessage()});
            return false;
        }
    }

    public static class DynamicRegistry<T> {
        private final Map<String, Supplier<T>> entries = new HashMap<String, Supplier<T>>();
        private final String registryName;

        public DynamicRegistry(String registryName) {
            this.registryName = registryName;
        }

        public void register(String key, Supplier<T> supplier) {
            this.entries.put(key, supplier);
        }

        public Supplier<T> get(String key) {
            return this.entries.get(key);
        }

        public Map<String, Supplier<T>> getAll() {
            return new HashMap<String, Supplier<T>>(this.entries);
        }

        public boolean contains(String key) {
            return this.entries.containsKey(key);
        }

        public int size() {
            return this.entries.size();
        }

        public String getRegistryName() {
            return this.registryName;
        }
    }
}

