/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.platform;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;

public abstract class PlatformRegistryHelper {
    public abstract Supplier<Block> registerWorkstationBlock(String var1, String var2, Supplier<Block> var3);

    public abstract Supplier<Item> registerWorkstationItem(String var1, String var2, Supplier<Item> var3);

    public abstract Supplier<VillagerType> registerVillagerType(String var1, String var2, Supplier<VillagerType> var3);

    public abstract Supplier<MapDecorationType> registerMapDecorationType(String var1, String var2, Supplier<MapDecorationType> var3);

    public abstract Supplier<VillagerProfession> registerProfession(String var1, String var2, Supplier<VillagerProfession> var3);

    public abstract Supplier<PoiType> registerPoiType(String var1, String var2, Supplier<Set<BlockState>> var3);

    public abstract boolean isModLoaded(String var1);

    public abstract Path getGameDirectory();

    protected ResourceLocation createResourceLocation(String namespace, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name);
    }

    protected boolean isValidBlock(ResourceLocation blockId) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
        return block != null && !block.equals(BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)"air")));
    }

    protected boolean isValidItem(ResourceLocation itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        return item != null && !item.equals(BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)"air")));
    }

    protected PoiType createPoiType(Set<BlockState> states) {
        return new PoiType(states, 1, 1);
    }
}

