/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.neoforge.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.villagerpack.VillagerPackHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackResourceManager;
import java.util.ArrayList;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="villagerapi", bus=EventBusSubscriber.Bus.MOD)
public class VillagerPackRegistrationNeoForge {
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        PackType packType = event.getPackType();
        ArrayList<VillagerPackResourceManager.PackFilter> filters = new ArrayList<VillagerPackResourceManager.PackFilter>();
        filters.add(VillagerPackResourceManager.PackFilter.HAS_CONFIG);
        if (packType == PackType.SERVER_DATA) {
            filters.add(VillagerPackResourceManager.PackFilter.HAS_DATA);
        } else if (packType == PackType.CLIENT_RESOURCES) {
            filters.add(VillagerPackResourceManager.PackFilter.HAS_ASSETS);
        }
        VillagerPackResourceManager.DiscoveryResult result = VillagerPackResourceManager.discoverAndProcessPacks(filters, pack -> {
            String displayName = pack.getDisplayName();
            String namespace = pack.getNamespace();
            event.addRepositorySource(consumer -> {
                Pack registeredPack = VillagerPackHelper.createPack(pack.getPath(), displayName, packType);
                if (registeredPack != null) {
                    consumer.accept(registeredPack);
                    VillagerAPI.LOGGER.info("Registered villagerpack '{}' as {} (namespace: {})", new Object[]{displayName, packType.name(), namespace});
                } else {
                    VillagerAPI.LOGGER.warn("Failed to create pack for villagerpack: {}", (Object)displayName);
                }
            });
        });
        if (result.getSkippedCount() > 0) {
            VillagerAPI.LOGGER.debug("Skipped {} pack(s) for {} registration (missing required content)", (Object)result.getSkippedCount(), (Object)packType.name());
        }
    }
}

