/*
 * Decompiled with CFR 0.152.
 */
package com.neotech.hephafix.capability;

import com.neotech.hephafix.HephaFix;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class HephaestusCenterSlotHandler
implements IItemHandler {
    public static final int CENTER_SLOT_INDEX = 0;
    private static final Map<Class<?>, Integer> MAIN_SLOT_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Field> HANDLER_FIELD_CACHE = new ConcurrentHashMap();
    private static final Set<Class<?>> FAILED_CLASSES = ConcurrentHashMap.newKeySet();
    private static final Map<BlockEntity, ItemStackHandler> HANDLER_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final BlockEntity be;

    public HephaestusCenterSlotHandler(BlockEntity forgeBe, int ignored) {
        this.be = forgeBe;
    }

    private Integer getMainSlotIndex() {
        Class<?> clazz = this.be.getClass();
        Integer cached = MAIN_SLOT_CACHE.get(clazz);
        if (cached != null) {
            return cached;
        }
        try {
            Field f = clazz.getDeclaredField("MAIN_SLOT");
            f.setAccessible(true);
            int value = f.getInt(null);
            MAIN_SLOT_CACHE.put(clazz, value);
            HephaFix.LOGGER.info("[HephaFix] MAIN_SLOT for {} is {}.", (Object)clazz.getName(), (Object)value);
            return value;
        }
        catch (Throwable t) {
            if (FAILED_CLASSES.add(clazz)) {
                HephaFix.LOGGER.warn("[HephaFix] Failed to resolve MAIN_SLOT on {}: {}", (Object)clazz.getName(), (Object)t.toString());
            }
            return null;
        }
    }

    private ItemStackHandler getItemStackHandler() {
        ItemStackHandler cached = HANDLER_CACHE.get(this.be);
        if (cached != null) {
            return cached;
        }
        Class<?> clazz = this.be.getClass();
        Field field = HANDLER_FIELD_CACHE.get(clazz);
        try {
            Object obj;
            if (field == null) {
                for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                    for (Field f : c.getDeclaredFields()) {
                        if (!ItemStackHandler.class.isAssignableFrom(f.getType())) continue;
                        f.setAccessible(true);
                        field = f;
                        HANDLER_FIELD_CACHE.put(clazz, field);
                        HephaFix.LOGGER.info("[HephaFix] Using {}.{} as Hephaestus forge itemStackHandler.", (Object)c.getName(), (Object)f.getName());
                        break;
                    }
                    if (field != null) break;
                }
                if (field == null) {
                    if (FAILED_CLASSES.add(clazz)) {
                        HephaFix.LOGGER.warn("[HephaFix] Could not find ItemStackHandler field on {}. HephaFix will expose an empty handler.", (Object)clazz.getName());
                    }
                    return null;
                }
            }
            if ((obj = field.get(this.be)) instanceof ItemStackHandler) {
                ItemStackHandler handler = (ItemStackHandler)obj;
                HANDLER_CACHE.put(this.be, handler);
                return handler;
            }
            if (FAILED_CLASSES.add(clazz)) {
                HephaFix.LOGGER.warn("[HephaFix] Field {} on {} is not an ItemStackHandler at runtime ({}).", new Object[]{field.getName(), clazz.getName(), obj != null ? obj.getClass().getName() : "null"});
            }
            return null;
        }
        catch (Throwable t) {
            if (FAILED_CLASSES.add(clazz)) {
                HephaFix.LOGGER.warn("[HephaFix] Error accessing itemStackHandler on {}: {}", (Object)clazz.getName(), (Object)t.toString());
            }
            return null;
        }
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        ItemStackHandler handler = this.getItemStackHandler();
        Integer mainIndex = this.getMainSlotIndex();
        if (handler == null || mainIndex == null) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(mainIndex.intValue()).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0 || stack.isEmpty()) {
            return stack;
        }
        ItemStackHandler handler = this.getItemStackHandler();
        Integer mainIndex = this.getMainSlotIndex();
        if (handler == null || mainIndex == null) {
            return stack;
        }
        ItemStack existing = handler.getStackInSlot(mainIndex.intValue());
        if (!existing.isEmpty()) {
            return stack;
        }
        if (stack.getCount() <= 1) {
            if (!simulate) {
                ItemStack toSet = stack.copy();
                toSet.setCount(1);
                handler.setStackInSlot(mainIndex.intValue(), toSet);
            }
            return ItemStack.EMPTY;
        }
        if (!simulate) {
            ItemStack toSet = stack.copy();
            toSet.setCount(1);
            handler.setStackInSlot(mainIndex.intValue(), toSet);
        }
        ItemStack remainder = stack.copy();
        remainder.shrink(1);
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0 || amount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStackHandler handler = this.getItemStackHandler();
        Integer mainIndex = this.getMainSlotIndex();
        if (handler == null || mainIndex == null) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = handler.getStackInSlot(mainIndex.intValue());
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getCount());
        ItemStack extracted = existing.copy();
        extracted.setCount(toExtract);
        if (!simulate) {
            ItemStack newStack = existing.copy();
            newStack.shrink(toExtract);
            if (newStack.isEmpty()) {
                handler.setStackInSlot(mainIndex.intValue(), ItemStack.EMPTY);
            } else {
                handler.setStackInSlot(mainIndex.intValue(), newStack);
            }
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot != 0 || stack.isEmpty()) {
            return false;
        }
        ItemStackHandler handler = this.getItemStackHandler();
        Integer mainIndex = this.getMainSlotIndex();
        if (handler == null || mainIndex == null) {
            return true;
        }
        return handler.isItemValid(mainIndex.intValue(), stack);
    }
}

