/*
 * Decompiled with CFR 0.152.
 */
package com.neotech.hephafix;

import com.mojang.logging.LogUtils;
import com.neotech.hephafix.capability.HephaestusCenterSlotHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.slf4j.Logger;

@Mod(value="hephafix")
public class HephaFix {
    public static final String MOD_ID = "hephafix";
    public static final Logger LOGGER = LogUtils.getLogger();

    public HephaFix(IEventBus modEventBus) {
        modEventBus.addListener(this::onRegisterCapabilities);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        BlockCapability cap = Capabilities.ItemHandler.BLOCK;
        ResourceLocation forgeBeId = ResourceLocation.fromNamespaceAndPath((String)"forbidden_arcanus", (String)"hephaestus_forge");
        BlockEntityType beType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(forgeBeId);
        if (beType == null) {
            LOGGER.warn("[HephaFix] Could not find forbidden_arcanus:hephaestus_forge block entity type. Is Forbidden & Arcanus installed? HephaFix will do nothing.");
            return;
        }
        LOGGER.info("[HephaFix] Found Forbidden & Arcanus Hephaestus Forge block entity, registering item handler capability.");
        event.registerBlockEntity(cap, beType, (blockEntity, side) -> new HephaestusCenterSlotHandler((BlockEntity)blockEntity, 0));
    }
}

